/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.util;

import dev.lambdaurora.lambdynlights.DynamicLightsConfig;
import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.engine.scheduler.ChunkRebuildStatus;
import dev.lambdaurora.spruceui.util.ColorUtil;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_12021;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_251;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_863;
import net.minecraft.class_9974;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public abstract class DynamicLightDebugRenderer
implements class_863.class_864 {
    final class_310 client = class_310.method_1551();
    final DynamicLightsConfig config;

    public DynamicLightDebugRenderer(LambDynLights mod) {
        this.config = mod.config;
    }

    static void renderFaces(class_4587 matrices, class_251 shape, class_2382 origin, class_4588 vertexConsumer, double x, double y, double z, int cellSize, int color) {
        shape.method_1046((direction, cellX, cellY, cellZ) -> {
            int realCellX = cellX + origin.method_10263();
            int realCellY = cellY + origin.method_10264();
            int realCellZ = cellZ + origin.method_10260();
            DynamicLightDebugRenderer.renderFace(matrices, vertexConsumer, direction, x, y, z, cellSize, realCellX, realCellY, realCellZ, color);
        });
    }

    static void renderEdges(class_4587 matrices, class_251 shape, class_2382 origin, class_4597 multiBufferSource, double x, double y, double z, int cellSize, int color) {
        shape.method_1064((startCellX, startCellY, startCellZ, endCellX, endCellY, endCellZ) -> {
            int realStartCellX = startCellX + origin.method_10263();
            int realStartCellY = startCellY + origin.method_10264();
            int realStartCellZ = startCellZ + origin.method_10260();
            int realEndCellX = endCellX + origin.method_10263();
            int realEndCellY = endCellY + origin.method_10264();
            int realEndCellZ = endCellZ + origin.method_10260();
            class_4588 vertexConsumer = multiBufferSource.method_73477(class_1921.method_49043((double)1.0));
            DynamicLightDebugRenderer.renderEdge(matrices, vertexConsumer, x, y, z, cellSize, realStartCellX, realStartCellY, realStartCellZ, realEndCellX, realEndCellY, realEndCellZ, color);
        }, true);
    }

    static void renderFace(class_4587 matrices, class_4588 vertexConsumer, class_2350 direction, double x, double y, double z, int cellSize, int cellX, int cellY, int cellZ, int color) {
        float faceX = (float)((double)(cellX * cellSize) - x);
        float faceY = (float)((double)(cellY * cellSize) - y);
        float faceZ = (float)((double)(cellZ * cellSize) - z);
        class_9974.method_62297((Matrix4f)matrices.method_23760().method_23761(), (class_4588)vertexConsumer, (class_2350)direction, (float)faceX, (float)faceY, (float)faceZ, (float)(faceX + (float)cellSize), (float)(faceY + (float)cellSize), (float)(faceZ + (float)cellSize), (float)ColorUtil.floatColor((int)ColorUtil.argbUnpackRed((int)color)), (float)ColorUtil.floatColor((int)ColorUtil.argbUnpackGreen((int)color)), (float)ColorUtil.floatColor((int)ColorUtil.argbUnpackBlue((int)color)), (float)ColorUtil.floatColor((int)ColorUtil.argbUnpackAlpha((int)color)));
    }

    static void renderEdge(class_4587 matrices, class_4588 vertexConsumer, double x, double y, double z, int cellSize, int startCellX, int startCellY, int startCellZ, int endCellX, int endCellY, int endCellZ, int color) {
        float startX = (float)((double)(startCellX * cellSize) - x);
        float startY = (float)((double)(startCellY * cellSize) - y);
        float startZ = (float)((double)(startCellZ * cellSize) - z);
        float endX = (float)((double)(endCellX * cellSize) - x);
        float endY = (float)((double)(endCellY * cellSize) - y);
        float endZ = (float)((double)(endCellZ * cellSize) - z);
        DynamicLightDebugRenderer.renderLine(matrices, vertexConsumer, startX, startY, startZ, endX, endY, endZ, color);
    }

    static void renderLine(class_4587 matrices, class_4588 vertexConsumer, float startX, float startY, float startZ, float endX, float endY, float endZ, int color) {
        Matrix4f modelMatrix = matrices.method_23760().method_23761();
        vertexConsumer.method_22918(modelMatrix, startX, startY, startZ).method_39415(color);
        vertexConsumer.method_22918(modelMatrix, endX, endY, endZ).method_39415(color);
    }

    public static class SectionRebuild
    extends DynamicLightDebugRenderer {
        private static final int SCHEDULED_COLOR = 1057004031;
        private static final int REQUESTED_COLOR = 1067122854;
        private final Long2IntMap scheduledChunks = new Long2IntOpenHashMap();
        private Long2ObjectMap<int[]> requestedChunks;

        public SectionRebuild(LambDynLights mod) {
            super(mod);
        }

        public boolean isEnabled() {
            return (Boolean)this.config.getDebugDisplayDynamicLightingChunkRebuilds().get();
        }

        public void method_23109(@NotNull class_4587 matrices, @NotNull class_4597 bufferSource, double x, double y, double z, @NotNull class_12021 debugValueAccess, @NotNull class_4604 frustum) {
            if (!this.isEnabled()) {
                return;
            }
            matrices.method_22903();
            matrices.method_22904(-x, -y, -z);
            for (Long2IntMap.Entry entry : this.scheduledChunks.long2IntEntrySet()) {
                this.renderBox(matrices, bufferSource, 1057004031, (float)entry.getIntValue() / 4.0f, class_4076.method_18677((long)entry.getLongKey()));
            }
            matrices.method_22909();
            if (this.requestedChunks != null) {
                for (Long2ObjectMap.Entry chunk : this.requestedChunks.long2ObjectEntrySet()) {
                    class_4076 chunkPos = class_4076.method_18677((long)chunk.getLongKey());
                    int[] statuses = (int[])chunk.getValue();
                    boolean canRenderBox = false;
                    int statusY = chunkPos.method_19531() - 4;
                    for (int i = 0; i < statuses.length; ++i) {
                        if (statuses[i] > 0) {
                            ChunkRebuildStatus status = ChunkRebuildStatus.VALUES.get(i);
                            class_863.method_23106((class_4587)matrices, (class_4597)bufferSource, (String)(statuses[i] + "x " + String.valueOf((Object)status)), (double)(chunkPos.method_19527() + 8), (double)statusY, (double)(chunkPos.method_19529() + 8), (int)status.color(), (float)0.08f);
                            if (i != ChunkRebuildStatus.AFFECTED.ordinal()) {
                                canRenderBox = true;
                            }
                        }
                        statusY -= 2;
                    }
                    if (!canRenderBox) continue;
                    matrices.method_22903();
                    matrices.method_22904(-x, -y, -z);
                    this.renderBox(matrices, bufferSource, 1067122854, 1.0f, chunkPos);
                    matrices.method_22909();
                }
            }
        }

        private void renderBox(class_4587 matrices, class_4597 bufferSource, int color, float alpha, class_4076 chunk) {
            float red = ColorUtil.floatColor((int)ColorUtil.argbUnpackRed((int)color));
            float green = ColorUtil.floatColor((int)ColorUtil.argbUnpackGreen((int)color));
            float blue = ColorUtil.floatColor((int)ColorUtil.argbUnpackBlue((int)color));
            class_9974.method_62292((class_4587.class_4665)matrices.method_23760(), (class_4588)bufferSource.method_73477(class_1921.method_23594()), (double)chunk.method_19527(), (double)chunk.method_19528(), (double)chunk.method_19529(), (double)class_4076.method_32205((int)chunk.method_18674(), (int)16), (double)class_4076.method_32205((int)chunk.method_18683(), (int)16), (double)class_4076.method_32205((int)chunk.method_18687(), (int)16), (float)red, (float)green, (float)blue, (float)alpha);
        }

        public void scheduleChunkRebuild(long chunkPos) {
            if (!this.isEnabled()) {
                return;
            }
            this.scheduledChunks.put(chunkPos, 4);
        }

        public void setRequestedChunks(Supplier<Long2ObjectMap<int[]>> chunks) {
            if (!this.isEnabled()) {
                return;
            }
            this.requestedChunks = chunks.get();
        }

        public void clearRequestedChunks() {
            this.requestedChunks = Long2ObjectMaps.emptyMap();
        }

        public void tick() {
            if (!this.isEnabled()) {
                return;
            }
            ObjectIterator iterator = this.scheduledChunks.long2IntEntrySet().iterator();
            while (iterator.hasNext()) {
                Long2IntMap.Entry entry = (Long2IntMap.Entry)iterator.next();
                if (entry.getIntValue() == 0) {
                    iterator.remove();
                    continue;
                }
                entry.setValue(entry.getIntValue() - 1);
            }
        }
    }
}

